#include <windows.h>
#include <stdlib.h>
#include <stdio.h>

struct convert_options
{
	int html_type;			//0-XHTML, 1- HTML, 2-HTML+CSS
	char title[120];		//Page title	
	char extension[10];		//for example, ".html"
	char font_face[50];		//for example, "Arial" or "Times New Roman"
	char font_size[10];		//for example ,"10"
	int preserve_images;	//0-no, 1 - yes 
	int preserve_font_face; //0-no, 1 - yes 
	int preserve_font_size; //0-no, 1 - yes 
	int preserve_font_color;//0-no, 1 - yes 
	int preserve_hyperlinks;//0-no, 1 - yes
	int table_borders;		//0-invisble, 1 - visible
	int encoding;			/* 	Windows_1250=0, Windows_1251=1, Windows_1252=2, Windows_1253=3,
								Windows_1254=4, Windows_1255=5, Windows_1256=6, Windows_1257=7,
								Windows_1258=8, ISO_8859_1=9,	ISO_8859_2=10,	ISO_8859_3=11,
								ISO_8859_4=12,	ISO_8859_5=13,	ISO_8859_6=14,	ISO_8859_7=15,
								ISO_8859_8=16,	ISO_8859_9=17,	KOI8_R=18,		UTF_8=19	*/
	int html_parts;			//0-html Complete, 1 - only between <body>..</body>
	char image_folder[500];	//folder where image will be stored
};

typedef int (* cfunc)(char * rtffile, char *outfolder, struct convert_options);
cfunc rtftohtml_file;


int main() 
{	

	int ret;
	char rtffile[_MAX_PATH];
	char outfolder[_MAX_PATH];

	//load library
	HINSTANCE hMod=LoadLibrary("rtftohtml_sautinsoft.dll");

	if(hMod==NULL) 
	{
	  printf("Unable to load library\n");
	  getchar();
	  return 0;
	}
	rtftohtml_file=(cfunc)GetProcAddress(hMod,"rtftohtml_file");
	if (rtftohtml_file==NULL)
	{
		printf("Can't load function.\n");
		FreeLibrary((HMODULE)hMod);
		getchar();
		return 0;
	}
	//
	printf("Please enter rtf file (example: d:\\my.rtf):\n");
	gets(rtffile);
	printf("Please enter output folder (example : d:\\temp):\n");
	gets(outfolder);

	//execute
	struct convert_options ct;
	ct.encoding=9;
	strcpy(ct.extension,".htm");
	strcpy(ct.font_face,"Verdana");
	strcpy(ct.font_size,"10");
	ct.html_type=1;
	ct.preserve_font_color=1;
	ct.preserve_font_face=1;
	ct.preserve_font_size=1;
	ct.preserve_images=1;
	ct.table_borders=1;
	strcpy(ct.title,"My Page");

	
	ret=rtftohtml_file(rtffile,outfolder,ct);

	switch(ret)
	{
		case 0 : puts("Conversion completed");break;
		case 2 : puts("Not enough memory"); break;
		case 3 : puts("Can't open output file"); break;
		case 4 : puts("Can't open input file"); break;
		case 5 : puts("The input file has zerow length"); break;
		default: break;
	}

	getchar();
	FreeLibrary((HMODULE)hMod);
	return 0;
}